	clear all
	close all
	clc
	Amax = 0.2; Amin = 60; wcT = 0.0522*pi; wsT = 0.1*pi;
	N = CA_ORDER_Z(wcT, wsT, Amax, Amin);
	N = 5; 
	[Gd, Zd, R_ZEROS, Pd, wsTnew] = CA_POLES_Z(wcT, wsT, Amax, Amin, N)
	%	Initial values
	%	x0 = [maxPhErr d Allpass_coefficients(3:6)];
	x0 = [0.1 80 -0.9 1.5 -0.9 1.5];
	vlb = [0 70 -0.999*ones(1, 4)]; 		% Lower bounds
	vub = [1 90 0.999*ones(1, 4)];			% Upper bounds
	wTp = linspace(0, 0.05*pi, 500);
	HLP = PZ_2_FREQ_Z(Gd, Zd, Pd, wTp);	% Lowpass filter
	x = minimax('EX_9_14_fun', x0, [], vlb, vub, [], HLP, wTp);
%	x = fminimax('EX_9_14_fun', x0, [], vlb, vub, [], HLP, wTp);		
	maxPhErr = x(1)		% Phase deviation
	d = x(2)			% Phase delay
	coeffAP = x(3:6)	% Adaptor coefficients, see Chapter 11
	Dap = conv([1 x(4)*(x(3)-1) -x(3)], [1 x(6)*(x(5)-1) -x(5)]);
	Pap = roots(Dap); Nap = fliplr(Dap); Zap = roots(Nap)
	Hap = freqz(Nap, Dap, wTp);
	Ph = unwrap(angle(HLP.*Hap));	
	subplot(2,1,1)
	wT = linspace(0, pi, 1000);
	Att = H_2_ATT(PZ_2_FREQ_Z(Gd, Zd, Pd, wT));
	PLOT_ATT_Z(wT, Att, pi, 80)
	subplot(2,1,2)
	PLOT_DELTA_PHASE_Z(wTp, Ph+x(2)*wTp, -0.02, 0.02);
